#ifndef __PLATFORM_OPTS_BT_H__
#define __PLATFORM_OPTS_BT_H__
#include "platform_autoconf.h"

#if defined CONFIG_BT && CONFIG_BT
#define CONFIG_FTL_ENABLED
#endif

#if defined CONFIG_BT_SCATTERNET && CONFIG_BT_SCATTERNET
#undef CONFIG_BT_PERIPHERAL
#undef CONFIG_BT_CENTRAL
#define CONFIG_BT_PERIPHERAL		1
#define CONFIG_BT_CENTRAL			1
#endif

#if ((defined CONFIG_BT_MESH_PROVISIONER && CONFIG_BT_MESH_PROVISIONER) || \
    (defined CONFIG_BT_MESH_DEVICE && CONFIG_BT_MESH_DEVICE) || \
    (defined CONFIG_BT_MESH_PROVISIONER_MULTIPLE_PROFILE && CONFIG_BT_MESH_PROVISIONER_MULTIPLE_PROFILE) || \
    (defined CONFIG_BT_MESH_DEVICE_MULTIPLE_PROFILE && CONFIG_BT_MESH_DEVICE_MULTIPLE_PROFILE))
#define CONFIG_BT_MESH_USER_API		1
#define CONFIG_BT_MESH_IDLE_CHECK	0
#endif

#if defined CONFIG_BT_MESH_PROVISIONER_RTK_DEMO && CONFIG_BT_MESH_PROVISIONER_RTK_DEMO
#undef CONFIG_BT_CONFIG
#define CONFIG_BT_CONFIG			1
#endif

#if ((defined CONFIG_BT_MESH_PROVISIONER && CONFIG_BT_MESH_PROVISIONER) && (defined CONFIG_BT_MESH_DEVICE && CONFIG_BT_MESH_DEVICE))
#error "CONFIG_BT_MESH_PROVISIONER & CONFIG_BT_MESH_DEVICE can not open at the same time"
#endif

#if ((defined CONFIG_BT_MESH_PROVISIONER_MULTIPLE_PROFILE && CONFIG_BT_MESH_PROVISIONER_MULTIPLE_PROFILE) && (defined CONFIG_BT_MESH_DEVICE_MULTIPLE_PROFILE && CONFIG_BT_MESH_DEVICE_MULTIPLE_PROFILE))
#error "CONFIG_BT_MESH_PROVISIONER_MULTIPLE_PROFILE & CONFIG_BT_MESH_DEVICE_MULTIPLE_PROFILE can not open at the same time"
#endif

#if (((defined CONFIG_BT_MESH_CENTRAL && CONFIG_BT_MESH_CENTRAL) && (defined CONFIG_BT_MESH_PERIPHERAL && CONFIG_BT_MESH_PERIPHERAL)) || \
    ((defined CONFIG_BT_MESH_CENTRAL && CONFIG_BT_MESH_CENTRAL) && (defined CONFIG_BT_MESH_SCATTERNET && CONFIG_BT_MESH_SCATTERNET)) || \
    ((defined CONFIG_BT_MESH_PERIPHERAL && CONFIG_BT_MESH_PERIPHERAL) && (defined CONFIG_BT_MESH_SCATTERNET && CONFIG_BT_MESH_SCATTERNET)) || \
    ((defined CONFIG_BT_MESH_CENTRAL && CONFIG_BT_MESH_CENTRAL) && (defined CONFIG_BT_MESH_PERIPHERAL && CONFIG_BT_MESH_PERIPHERAL) && (defined CONFIG_BT_MESH_SCATTERNET && CONFIG_BT_MESH_SCATTERNET)))
#error "Only one of CONFIG_BT_MESH_CENTRAL, CONFIG_BT_MESH_PERIPHERAL and CONFIG_BT_MESH_SCATTERNET can be enabled"
#endif

#endif // __PLATFORM_OPTS_BT_H__

